class CTFBase1 extends Actor;

var byte Team;	// Player Team, 255 = None for player.
var CTF1Flag OtherFlag;
var CTF2FlagRed OtherFlag2;
var MSGamesMutator MSMod;
var FlagSpawn FlagSpawn;
var CTFBase2 RedBase;

function Tick(float Deltatime)
{
 
 ForEach AllActors(class'CTF1Flag',OtherFlag)
 { 
  if (OtherFlag != None)
  {
   CheckBases(OtherFlag);
  }
 }
 ForEach AllActors(class'CTF2FlagRed',OtherFlag2)
 { 
  if (OtherFlag2 != None)
  {
   CheckBases2(OtherFlag2);
  }
 }
}

function CheckBases(CTF1Flag OtherFlag)
{
    ForEach VisibleActors(class'CTF1Flag',OtherFlag,DrawScale*10,Location)
    {
     ForEach AllActors(class'FlagSpawn',FlagSpawn)
     { 
     ForEach AllActors(class'MSGamesMutator',MSMod)
     {
      if ((MSMod.bInCTF1) && (FlagSpawn != None) && (OtherFlag != None))
      {
       if (OtherFlag.Base != None)
       {
        return;
       }
       else
       {
        MSMod.BlueScore += 1;
        BroadcastMessage("|p7Team Blue has scored! They now have "$MSMod.BlueScore$" points!", true, 'CriticalEvent');
        OtherFlag.SetLocation(FlagSpawn.Location);
       }
      }
     }
    } 
   }
}
function CheckBases2(CTF2FlagRed OtherFlag2)
{
    ForEach VisibleActors(class'CTF2FlagRed',OtherFlag2,DrawScale*10,Location)
    {
     ForEach AllActors(class'MSGamesMutator',MSMod)
     {
     ForEach AllActors(class'CTFBase2',RedBase)
     {
      if ((MSMod.bInCTF2) && (RedBase != None) && (OtherFlag2 != None))
      {
       if (OtherFlag2.Base != None)
       {
        return;
       }
       else
       {
        MSMod.BlueScore += 1;
        BroadcastMessage("|p7Team Blue has scored! They now have "$MSMod.BlueScore$" points!", true, 'CriticalEvent');
        OtherFlag2.SetLocation(RedBase.Location);
       }
      }
     }
     }
    } 
}

defaultproperties
{
     Style=STY_Translucent
     Mesh=LodMesh'DeusExItems.SphereEffect'
     bUnlit=True
     Team=1
     bCollideActors=False
     bCollideWorld=False
     bProjTarget=False
     DrawType=DT_Mesh
     Physics=PHYS_None
     Texture=FireTexture'Effects.Electricity.Nano_SFX_A'
     Skin=FireTexture'Effects.Electricity.Nano_SFX_A'
     DrawScale=10.000000
     MultiSkins(0)=FireTexture'Effects.Electricity.Nano_SFX_A'
}
